using System;
using System.Data;
using System.Collections;
using System.Text.RegularExpressions;
using System.Text;
using gov.va.med.vbecs.DAL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.ExceptionManagement;
using Method = System.Reflection.MethodBase;
//
namespace gov.va.med.vbecs.BOL
{
    #region Header
		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> 
		///WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified
		///</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<Note>
		///The Food and Drug Administration classifies this software as a medical device.  
		///As such, it may not be changed in any way. Modifications to this software may result 
		///in an adulterated medical device under 21CFR820, the use of which is considered to 
		///be a violation of US Federal Statutes.  Acquiring and implementing this software through 
		///the Freedom of information Act requires the implementor to assume total responsibility 
		///for the software, and become a registered manufacturer of a medical device, subject 
		///to FDA regulations
		///</Note>
		///<summary>
		///TransfusionReactionType reference object.
		///</summary>
    #endregion

    #region TransfusionReactionType

    public class TransfusionReactionType
    {
        DataTable _transfusionReactionTypeDataTable;
        DataRow _transfusionReactionTypeDataRow;
        

        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7857"> 
		///		<ExpectedInput>Valid transfusion reaction type code</ExpectedInput>
		///		<ExpectedOutput>Transfusion reaction type object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7858"> 
		///		<ExpectedInput>Invalid transfusion reaction type code</ExpectedInput>
		///		<ExpectedOutput>Data access layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Create an instance of TransfusionReactionType based on its "TransfusionReactionTypeCode".
        /// </summary>
        public TransfusionReactionType(char transfusionReactionTypeCode)
        {
            GetTransfusionReactionTypeData(transfusionReactionTypeCode);
        }

		/// <summary>
		/// Load properties from DataRow
		/// </summary>
		/// <param name="dataRow"></param>
        protected void LoadFromDataRow(DataRow dataRow)
        {
            _transfusionReactionTypeDataTable = dataRow.Table;
            _transfusionReactionTypeDataRow = dataRow;
        }
        
        private void GetTransfusionReactionTypeData(char transfusionReactionTypeCode)
        {
            //_transfusionReactionTypeDataTable = DAL.TransfusionReactionType.GetTransfusionReactionType(transfusionReactionTypeCode);
            LoadFromDataRow(DAL.ReferenceData.GetTransfusionReactionType(transfusionReactionTypeCode));
        }
       
		#region Public Properties
       
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7859"> 
		///		<ExpectedInput>Valid transfusion reaction type object</ExpectedInput>
		///		<ExpectedOutput>Transfusion reaction type code</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7860"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// string value containing the transfusion reaction type code
        /// </summary>
        public Common.TransfusionReactionType TransfusionReactionTypeCode
        {
			
            get 
            {
                if (_transfusionReactionTypeDataRow.IsNull(Common.VbecsTables.TransfusionReactionType.TransfusionReactionTypeCode))
                {
                    return Common.TransfusionReactionType.Unknown;
                }
                return GetTransfusionReactionTypeEnum(Convert.ToChar(_transfusionReactionTypeDataRow[Common.VbecsTables.TransfusionReactionType.TransfusionReactionTypeCode]));
            }
        }
        		
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7861"> 
		///		<ExpectedInput>Valid transfusion reaction type object</ExpectedInput>
		///		<ExpectedOutput>Transfusion reaction type text</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7862"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// string value containing the transfusion reaction type text
        /// </summary>
        public string TransfusionReactionTypeText
        {
			
            get 
            {
                if (_transfusionReactionTypeDataRow.IsNull(Common.VbecsTables.TransfusionReactionType.TransfusionReactionTypeText))
                {
                    return "";
                }
                return (string)_transfusionReactionTypeDataRow[Common.VbecsTables.TransfusionReactionType.TransfusionReactionTypeText];
            }
        }
        		
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7863"> 
		///		<ExpectedInput>Valid transfusion reaction type object</ExpectedInput>
		///		<ExpectedOutput>Sort column</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7864"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// short value containing the sort column
        /// </summary>
        public short SortColumn
        {
			
            get 
            {
                if (_transfusionReactionTypeDataRow.IsNull(Common.VbecsTables.TransfusionReactionType.SortColumn))
                {
                    return 0;
                }
                return (short)_transfusionReactionTypeDataRow[Common.VbecsTables.TransfusionReactionType.SortColumn];
            }
        }
       		
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7865"> 
		///		<ExpectedInput>Valid transfusion reaction type object</ExpectedInput>
		///		<ExpectedOutput>Last update date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7866"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// DateTime value containing the last update date
        /// </summary>
        public DateTime LastUpdateDate
        {
			
            get 
            {
                if (_transfusionReactionTypeDataRow.IsNull(Common.VbecsTables.TransfusionReactionType.LastUpdateDate))
                {
                    return System.DateTime.MinValue;
                }
                return (DateTime)_transfusionReactionTypeDataRow[Common.VbecsTables.TransfusionReactionType.LastUpdateDate];
            }
        }
        		
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7867"> 
		///		<ExpectedInput>Valid transfusion reaction type object</ExpectedInput>
		///		<ExpectedOutput>Last update user</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7868"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// string value containing the last update user
        /// </summary>
        public string LastUpdateUser
        {
			
            get 
            {
                if (_transfusionReactionTypeDataRow.IsNull(Common.VbecsTables.TransfusionReactionType.LastUpdateUser))
                {
                    return "";
                }
                return (string)_transfusionReactionTypeDataRow[Common.VbecsTables.TransfusionReactionType.LastUpdateUser];
            }
        }
        		
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7869"> 
		///		<ExpectedInput>Valid transfusion reaction type object</ExpectedInput>
		///		<ExpectedOutput>Row version</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7870"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// byte array value containing the row version
        /// </summary>
        public byte[] RowVersion
        {
			
            get 
            {
                if (_transfusionReactionTypeDataRow.IsNull(Common.VbecsTables.TransfusionReactionType.RowVersion))
                {
                    return null;
                }
                return (byte[])_transfusionReactionTypeDataRow[Common.VbecsTables.TransfusionReactionType.RowVersion];
            }
        }
				
		#endregion

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7871"> 
		///		<ExpectedInput>Valid transfusion reaction type code</ExpectedInput>
		///		<ExpectedOutput>Transfusion reaction type object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7872"> 
		///		<ExpectedInput>Invalid transfusion reaction type code</ExpectedInput>
		///		<ExpectedOutput>Data access layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a TransfusionReactionType from transfusionReactionTypeCode
		/// </summary>
		/// <param name="transfusionReactionTypeCode"></param>
		/// <returns></returns>
        public static TransfusionReactionType GetTransfusionReactionType(char transfusionReactionTypeCode)
        {
            return new TransfusionReactionType(transfusionReactionTypeCode);
        }

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7873"> 
		///		<ExpectedInput>Valid reaction type code char</ExpectedInput>
		///		<ExpectedOutput>Transfusion Reaction Type enum</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7874"> 
		///		<ExpectedInput>Invalid reaction type code char</ExpectedInput>
		///		<ExpectedOutput>Transfusion Reaction Type of unknown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the enumeration representation of a TransfusionReactionTypeCode from a char.
		/// </summary>
		/// <param name="reactionTypeCode"></param>
		/// <returns>enumeration representation of TransfusionReactionTypeCode char</returns>
		public static Common.TransfusionReactionType GetTransfusionReactionTypeEnum(char reactionTypeCode) 
		{
			Common.TransfusionReactionType TransfusionReactionType;
			//
			switch(reactionTypeCode)
			{
				case ('A'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.Anaphylaxis;
					break;
				}
				case ('C'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.Circulatory;
					break;
				}
				case ('D'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.DelayedHemolytic;
					break;
				}
				case ('F'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.FebrileNonHemolytic;
					break;
				}
				case ('G'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.GraftVsHostDisease;
					break;
				}
				case ('H'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.AcuteHemolytic;
					break;
				}
				case ('L'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.TransfusionRelatedAcuteLungInjury;
					break;
				}
				case ('O'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.Other;
					break;
				}
				case ('P'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.PostTransfusion;
					break;
				}
				case ('U'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.Uticaria;
					break;
				}
				//CR 3179
				case ('J'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.AcuteHemolysisNonABO;
					break;
				}
				case ('Q'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.CitrateToxicity;
					break;
				}				
				case ('R'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.UnrelatedToTransfusion;
					break;
				}
				case ('Z'):
				{
					TransfusionReactionType = Common.TransfusionReactionType.TransfusionRelatedMicrobialInfection;
					break;
				}
				default:
				{
					TransfusionReactionType = Common.TransfusionReactionType.Unknown;
					break;
				}
			}
			return TransfusionReactionType;
		}

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7875"> 
		///		<ExpectedInput>Valid transfusion reaction type enum</ExpectedInput>
		///		<ExpectedOutput>Transfusion reaction type char</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7876"> 
		///		<ExpectedInput>Invalid transfusion reaction type enum</ExpectedInput>
		///		<ExpectedOutput>char.MinValue</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to get the char representation of a TransfusionReactionTypeCode from an enumeration.
		/// </summary>
		/// <param name="reactionType"></param>
		/// <returns>char representation of TransfusionReactionType</returns>
		public static char GetTransfusionReactionTypeCharFromEnum(Common.TransfusionReactionType reactionType) 
		{
			char reactionTypeCode;
			//
			switch(reactionType)
			{
				case (Common.TransfusionReactionType.Anaphylaxis):
				{
					reactionTypeCode = 'A';
					break;
				}
				case (Common.TransfusionReactionType.Circulatory):
				{
					reactionTypeCode = 'C';
					break;
				}
				case (Common.TransfusionReactionType.DelayedHemolytic):
				{
					reactionTypeCode = 'D';
					break;
				}
				case (Common.TransfusionReactionType.FebrileNonHemolytic):
				{
					reactionTypeCode = 'F';
					break;
				}
				case (Common.TransfusionReactionType.GraftVsHostDisease):
				{
					reactionTypeCode = 'G';
					break;
				}
				case (Common.TransfusionReactionType.AcuteHemolytic):
				{
					reactionTypeCode = 'H';
					break;
				}
				case (Common.TransfusionReactionType.TransfusionRelatedAcuteLungInjury):
				{
					reactionTypeCode = 'L';
					break;
				}
				case (Common.TransfusionReactionType.Other):
				{
					reactionTypeCode = 'O';
					break;
				}
				case (Common.TransfusionReactionType.PostTransfusion):
				{
					reactionTypeCode = 'P';
					break;
				}
				case (Common.TransfusionReactionType.Uticaria):
				{
					reactionTypeCode = 'U';
					break;
				}
				//CR 3179
				case (Common.TransfusionReactionType.AcuteHemolysisNonABO):
				{
					reactionTypeCode = 'J';
					break;
				}
				case (Common.TransfusionReactionType.CitrateToxicity):
				{
					reactionTypeCode = 'Q';
					break;
				}
				case (Common.TransfusionReactionType.UnrelatedToTransfusion):
				{
					reactionTypeCode = 'R';
					break;
				}
				case (Common.TransfusionReactionType.TransfusionRelatedMicrobialInfection):
				{
					reactionTypeCode = 'Z';
					break;
				}
				default:
				{
					reactionTypeCode = char.MinValue;
					break;
				}
			}
			return reactionTypeCode;
		}
    }
	#endregion
}
